<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>IBSheet7-Product</title>

	<script type="text/javascript" src="../js/common.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts-more.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/gantt.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/modules/boost.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	<script type="text/javascript" src="./chartTypeOptions.js"></script>

	<script type="text/javascript" src="https://unpkg.com/canvg@3.0.4/lib/umd.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("#barChart")[0]
			createIBChart("barChartDIV", "barChart", {
				width: "100%",
				height: "85%"
			});

			barChartDraw();
		});

		//막대차트 유형 그리기
		function barChartDraw(){
			var Type = $("#barCombo").val();
			barChart.removeAll();
			barChart.setOptions(barChartOption); //막대차트 기본값 설정 (chartTypeOptions.js)
			switch(Type){
				case "BAR":  //바 (누운 막대) 차트
				barChart.setOptions({
					chart:{
						type:"bar"
					}
				},{
					append : true
				});
				break;

				case "BAR_Stacking_Normal": //누적바 차트
				barChart.setOptions({
					chart:{
						type:"bar"
					},
					plotOptions : {
						series: {
							stacking:"normal",  //누적
							dataLabels:{ //데이터 레이블을 데이터 가운데 표시
								enabled: true,
								align:"center"
							}
						}
					}
				},{
					append : true
				});
				break;

				case "BAR_Stacking": //100% 누적 바 차트
				barChart.setOptions({
					chart:{
						type:"bar"
					},
					plotOptions : {
						series: {
							stacking:"percent",  //누적
							dataLabels:{ //데이터 레이블을 데이터 가운데 표시
								enabled: true,
								align:"center"
							}
						}
					}
				},{
					append : true
				});
				break;
				case "BAR_Negative":  //음수 누적 바
				barChart.setOptions({
					chart:{
						type:"bar"
					},
					//Y축 레이블 설정
					yAxis: {
						title:{enabled:false},
						labels: {
							formatter: function () {
								//축레이블도 절대값 표시
								return Math.abs(this.value);
							}
						}
					},
					plotOptions : {
						series: {
							stacking:"normal",  //누적
							dataLabels:{ //데이터 레이블을 데이터 가운데 표시
								formatter:function(){
									return Math.abs(this.y);//음수값을 절대값으로 표시
								}
							}
						}
					},
					//툴팁에 절대값 표시
					tooltip: {
						formatter: function () {
							return '<b>' + this.series.name + '</b><br/>' +	Math.abs(this.point.y);//음수값을 절대값으로 표시
						}
					}
				},{
					append : true
				});

				break;
				case "COLUMN": //막대 차트
				break;
				case "COLUMN_Stacking_Group": //그룹 누적 막대
				case "COLUMN_Stacking_Normal": //누적 막대
				barChart.setOptions({
					plotOptions : {
						series: {
							stacking:"normal",  //누적
							dataLabels:{ //데이터 레이블을 데이터 가운데 표시
								enabled: true,
								align:"center"
							}
						}
					},
					events: {
						searchEnd: barChart_OnSearchEnd
					}
				},{
					append : true
				});
				break;

				case "COLUMN_Stacking": //누적 막대 100%
				barChart.setOptions({
					plotOptions : {
						series: {
							stacking:"percent",  //누적
							dataLabels:{ //데이터 레이블을 데이터 가운데 표시
								enabled: true,
								align:"center"
							}
						}
					}
				},{
					append : true
				});
				break;

				case "COLUMN_Gantt":
				barChart.setOptions({
					chart:{
						type:"columnrange",
						inverted:true
					}
				},{
					append : true,
					redraw: true
				});
				break;
			}

			//데이터 조회
			if(Type=="BAR_Negative"){
				doSearch(barChart,"chartdata_negativebar.json");

			}else if(Type=="COLUMN_Gantt"){
				doSearch(barChart,"chartdata_gantt.json");
			}else{
				doSearch(barChart,"chartdata.json");
			}
			//조회 후 callback event(OnSearchEnd 참고)
		}

		function Down2Image(Type){
			switch (Type)
			{
				case "PNG":
					//chart객체, 파일명
				downChart2Image(barChart,"막대차트.png");
				break;
			}
		}

		function doSearch(chart,url,subparam){
			$.ajax({
				type: 'post'
				, async: true
				, dataType:"text"
				, url: url
				, data:  subparam
				, beforeSend: function() {

				}
				, success: function(JSON) {
					chart.loadSearchData(JSON, {
						append: true
					});
				}
				, error: function(data, status, err) {
					alert('서버와의 통신이 실패했습니다.');
				}
				,complete:function(jqXHR,textStatus){

				}
			});
		}

		function bar3dUse(chk,draw){
			if(chk){
				barChart.setOptions({
					chart: {
						"backgroundColor": "rgba(255,255,255,0.002)",
						"plotBackgroundColor": "rgba(255,255,255,0.002)",
						"plotBorderWidth": 0,
						"options3d": {
							// "alpha":0,
							// "beta": -25,
							// "viewDistance": 100,
							// "enabled": true,
							"depth": 30
						}
					}
				}, {
					append: true
				});
			}else{
				barChart.setOptions({
					chart:{
						"plotBorderWidth": 1,
						"options3d": {
							"enabled": false,
							"depth": 40
						}
					}
				},{
					append : true
				});
			}
			if(draw){
				barChart.draw();
			}
		}

		function barChart_OnSearchEnd(code,msg){
			if($("#barCombo").val()=="COLUMN_Stacking_Group"){ //그룹 누적 막대 후처리
				//일부 시리즈를 다른 그룹에 편입한다.
				barChart.series(0).setOptions({
					stack: "major"
				},{
					append: true
				});
				barChart.series(1).setOptions({
					stack: "minor"
				},{
					append: true
				});
				barChart.series(2).setOptions({
					stack: "major"
				},{
					append: true
				});
				barChart.series(3).setOptions({
					stack: "minor"
				},{
					append: true,
					redraw: true
				});
			}
		}

		function DoPrint(){
			barChart.doPrint();
		}
	</script>
</head>
<body>
	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 유형 > <b>막대형 차트</b></span>
	</div>
	<div class="main_content">
		<div style="float:left;width:100%">
			<div class="exp_product" style="float:left;width:30%">
				막대형 차트를 확인합니다.
			</div>
			<div class="ib_function" style="float:left;width:70%;text-align:right">
				<a href="javascript:Down2Image('PNG')" class="f1_btn_white gray">이미지 다운로드</a>
				<a href="javascript:DoPrint()" class="f1_btn_white gray">이미지 프린트</a>
			</div>
		</div>
		<div class="clear hidden"></div>
		<p class="subtit_chart">차트 유형</p>
		<div class="ib_chart_product">
			<span class="chartCombo">
				차트종류 : <select  id="barCombo" onchange="barChartDraw()">
				<option value="BAR" >바</option>
				<option value="BAR_Stacking_Normal" >누적 바</option>
				<option value="BAR_Stacking" >100% 누적 바</option>
				<option value="BAR_Negative" >음수 누적 바</option>
				<option value="COLUMN" selected>막대</option>
				<option value="COLUMN_Stacking_Normal" >누적 막대</option>
				<option value="COLUMN_Stacking" >100% 누적 막대</option>
				<option value="COLUMN_Stacking_Group" >그룹 누적</option>
				<option value="COLUMN_Gantt" >간트</option>
			</select>
			<!-- 3D 사용 : <input type="checkbox" id="bar3dUseChk"  onchange="bar3dUse(this.checked,1)"> -->
			</span>
			<div style="height:10px"></div>
			<div id="barChartDIV"></div>
		</div>
	</div>
	<!--main_content-->

</body>
</html>